<?php
//função que remove todos os elementos que não sejam numeros
if(!function_exists('numeros'))
{
	function numeros($string)
	{ 
		if (!empty($string))
		{
			return preg_replace('/[^\d\-]/', '',$string);
		}
		else
		{
			return '';
		}
 	}
}

//converte para formato de moeda
if(!function_exists("currency")) {
	function currency($string)
	{
		if(!empty($string))
		{
			return number_format($string, 2, ',', '.');
		}
		else
		{
			return 0;
		}
	}
}

//url amigavel
if(!function_exists('preparaURL'))
{
	function preparaURL($tipo, $string)
	{

		$table = array(
				'Š'=>'S', 'š'=>'s', 'Ð'=>'D', 'd'=>'d', 'Ž'=>'Z',
				'ž'=>'z', 'C'=>'C', 'c'=>'c', 'C'=>'C', 'c'=>'c',
				'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A',
				'Å'=>'A', 'Æ'=>'A', 'Ç'=>'C', 'È'=>'E', 'É'=>'E',
				'Ê'=>'E', 'Ë'=>'E', 'Ì'=>'I', 'Í'=>'I', 'Î'=>'I',
				'Ï'=>'I', 'Ñ'=>'N', 'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O',
				'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ù'=>'U', 'Ú'=>'U',
				'Û'=>'U', 'Ü'=>'U', 'Ý'=>'Y', 'Þ'=>'B', 'ß'=>'Ss',
				'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a',
				'å'=>'a', 'æ'=>'a', 'ç'=>'c', 'è'=>'e', 'é'=>'e',
				'ê'=>'e', 'ë'=>'e', 'ì'=>'i', 'í'=>'i', 'î'=>'i',
				'ï'=>'i', 'ð'=>'o', 'ñ'=>'n', 'ò'=>'o', 'ó'=>'o',
				'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ù'=>'u',
				'ú'=>'u', 'û'=>'u', 'ý'=>'y', 'ý'=>'y', 'þ'=>'b',
				'ÿ'=>'y', 'R'=>'R', 'r'=>'r', '&'=>'e',
			);
			// Traduz os caracteres em $string, baseado no vetor $table
			$string = strtr($string, $table);
			// converte para minúsculo
			$string = strtolower($string);

			if(!isset($tipo))
			{
				// remove caracteres indesejáveis (que não estão no padrão)
				$string = preg_replace("/[^a-z0-9_\s-]/", "", $string);
			}
			

			// Remove múltiplas ocorrências de hífens ou espaços
			$string = preg_replace("/[\s-]+/", " ", $string);
			// Transforma espaços e underscores em hífens
			$string = preg_replace("/[\s_]/", "-", $string);
			// retorna a string
			return $string;
	}
}




//função para redirecionar usuário
if(!function_exists('redireciona'))
{
	function redireciona($string)
	{
		echo 
		'
			<script>
				setTimeout(function(){
					location.href="'.$string.'";
				}, 1500);
			</script> 
 		';
 	}
}

